% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuel_and_co2.R
\name{fuel_to_co2}
\alias{fuel_to_co2}
\title{Convert Fuel Consumption into CO2 Emission}
\usage{
fuel_to_co2(fuel_cons_ltrs, fuel_type = c("diesel"))
}
\arguments{
\item{fuel_cons_ltrs}{Fuel amount consumed by a harvester in liters.}

\item{fuel_type}{Fuel type (character string), required to find the correct
conversion factor. Currently, only "diesel" is accepted.}
}
\value{
The emitted amount of CO2 in kg coming form burning
\code{fuel_cons_ltrs}
}
\description{
Simple conversion assuming a factor of 2.61 kg CO2 / l diesel fuel
}
\examples{
  dbh  <- seq(20, 70, 10) # Vector of tree dbh in cm
  vol  <- dbh ^ 2 / 1000  # Simple Volume estimate (m³) with Denzin's formula

  fuel_cons_harvester_1(vol, dbh) |>
    fuel_to_co2()

}
