% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychsyn.R
\name{psychsyn}
\alias{psychsyn}
\title{Computes the psychometric synonym/antonym score}
\usage{
psychsyn(x, critval = 0.6, anto = FALSE, diag = FALSE)
}
\arguments{
\item{x}{is a matrix of item responses}

\item{critval}{is the minimum magnitude of the correlation between two items
in order for them to be considered psychometric synonyms. Defaults to .60}

\item{anto}{determines whether psychometric anonyms are returned instead of
psychometric synonyms. Defaults to \code{FALSE}}

\item{diag}{additionally return the number of item pairs available for each observation. Useful if dataset contains many missing values.}
}
\description{
Takes a matrix of item responses and identifies item pairs that are highly
correlated within the overall dataset.
What defines "highly correlated" is set by the critical value (e.g., r > .60).
Each respondents' psychometric synonym
score is then computed as the within-person correlation between the
identified item-pairs.
Alternatively computes the psychometric antonym score which is a
variant that uses item pairs that are highly \emph{negatively} correlated.
}
\examples{
synonyms <- psychsyn(careless_dataset, .60)
antonyms <- psychsyn(careless_dataset2, .50, anto = TRUE)
antonyms <- psychant(careless_dataset2, .50)

#with diagnostics
synonyms <- psychsyn(careless_dataset, .60, diag = TRUE)
antonyms <- psychant(careless_dataset2, .50, diag = TRUE)
}
\references{
Meade, A. W., & Craig, S. B. (2012). Identifying careless responses in survey data.
\emph{Psychological Methods, 17(3)}, 437-455. \doi{10.1037/a0028085}
}
\seealso{
\code{\link{psychant}} for a more concise way to calculate the psychometric antonym score,
 \code{\link{psychsyn_critval}} for a helper that allows to set an
adequate critical value for the size of the correlation.
}
\author{
Richard Yentes \email{rdyentes@ncsu.edu}, Francisco Wilhelm \email{franciscowilhelm@gmail.com}
}
