% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caretEnsemble.R
\name{autoplot}
\alias{autoplot}
\title{Convenience function for more in-depth diagnostic plots of caretEnsemble objects}
\usage{
autoplot(object, which = c(1:6), mfrow = c(3, 2), xvars = NULL, ...)
}
\arguments{
\item{object}{a \code{caretEnsemble} object}

\item{which}{an integer index for which of the plots to print.  DOES NOTHING.}

\item{mfrow}{an integer vector of length 2 specifying the number of rows and columns for plots}

\item{xvars}{a vector of the names of x variables to plot against residuals}

\item{...}{additional arguments to pass to autoplot}
}
\value{
A grid of diagnostic plots. Top left is the range of the performance
metric across each component model along with its standard deviation. Top right
is the residuals from the ensembled model plotted against fitted values.
Middle left is a bar graph of the weights of the component models. Middle
right is the disagreement in the residuals of the component models (unweighted)
across the fitted values. Bottom left and bottom right are the plots of the
residuals against two random or user specified variables.
}
\description{
This function provides a more robust series of diagnostic plots
for a caretEnsemble object.
}
\examples{
\dontrun{
set.seed(42)
models <- caretList(
 iris[1:50,1:2],
 iris[1:50,3],
 trControl=trainControl(method="cv"),
 methodList=c("glm", "rpart"))
ens <- caretEnsemble(models)
autoplot(ens)
}
}
