% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cargo.R
\name{run}
\alias{run}
\title{Run Cargo}
\usage{
run(..., minimum_version)
}
\arguments{
\item{...}{Character vector of command line arguments passed to the
\code{cargo} command.}

\item{minimum_version}{A character string representing the minimum version of
Rust that is needed.}
}
\value{
A logical equally \code{TRUE} if and only if the minimum version is
available and the exit status of the command is zero (indicating success).
The function should never throw a warning or error.
}
\description{
This function finds and runs Cargo (Rust's package manager) with the
\code{...} arguments passed as command line arguments but, by default, runs
according to CRAN policies.  First, it does not write to the user's file
system (e.g., \code{~/.cargo}). Second, it only uses at most two parallel
jobs when building (i.e., compiling).
}
\details{
To enable caching, set the \code{R_CARGO_SAVE_CACHE} environment variable to
\code{TRUE}. Then, if defined, the \code{R_CARGO_HOME} environment variable
will be used as the cache location. Otherwise, Cargo uses its default
behavior (usually writing to \code{~/.cargo} unless the \code{CARGO_HOME}
environment variable is set). Regardless of the location, the user is
responsible to maintaining and clearing the cache when using the
\code{R_CARGO_SAVE_CACHE} environment variable.

To enable a specific number of parallel jobs, set the
\code{R_CARGO_BUILD_JOBS} environment variable to the desired integer. If
\code{R_CARGO_BUILD_JOBS} is \code{0}, Cargo will use its default behavior
(usually using all the cores unless the \code{CARGO_BUILD_JOBS} environment
variable is set or the \code{--jobs} argument is provided).
}
\examples{
run(minimum_version="1.50")

}
\seealso{
\code{\link[base:Sys.setenv]{base::Sys.setenv()}}
}
