% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_coord_polygon.R
\name{to_coord_polygon}
\alias{to_coord_polygon}
\title{Transform from coordinates system used in flow based cartogram to coordinates
system used in the polygons}
\usage{
to_coord_polygon(coord, carto)
}
\arguments{
\item{coord}{a vector of length 2 or a two columns matrix containing
xy  coordinates to transform}

\item{carto}{a cartogramR object}
}
\value{
a vector of length 2 or a two columns matrix containing xy
coordinates in the coordinate systems of polygons used to build
the cartogram
}
\description{
Apply the mapping from the coordinates system used in flow based cartogram
to the coordinates system used in the polygons (caracterised by the CRS)
}
\examples{
 \donttest{
  data(usa)
  carto <- cartogramR(usa, "electors64")
  to_coord_polygon(c(256,256), carto)
 }


}
