% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTiles.R
\name{getTiles}
\alias{getTiles}
\title{Get Tiles from Open Map Servers}
\usage{
getTiles(spdf, type = "osm", zoom = NULL)
}
\arguments{
\item{spdf}{a Spatial*DataFrame with a valid projection attribute.}

\item{type}{the tile server from which to get the map, one of "osm", "osm-bw", 
"maptoolkit-topo", "waze", "mapquest", "mapquest-aerial", "bing", 
"stamen-toner", "stamen-terrain", "stamen-watercolor", "osm-german", 
"osm-wanderreitkarte", "mapbox", "esri", "esri-topo", "nps", "apple-iphoto", 
"skobbler", "cloudmade-<id>", "hillshade", "opencyclemap", "osm-transport", 
"osm-public-transport", "osm-bbike", "osm-bbike-german".}

\item{zoom}{the zoom level. If null, it is determined automatically 
(see Details).}
}
\value{
An OpenStreetMap object is returned.
}
\description{
Get map tiles based on a Spatial*DataFrame extent. Maps can be 
fetched from various open map servers.
}
\details{
Zoom levels are descibed on the OpenStreetMap wiki: 
\url{http://wiki.openstreetmap.org/wiki/Zoom_levels}.
}
\note{
This function uses \code{rgdal} and \code{OpenStreetMap} packages.
}
\examples{
\dontrun{
data("nuts2006")
# Download the tiles, nuts0.spdf extent
EuropeOsm <- getTiles(spdf = nuts0.spdf, type = "osm")
class(EuropeOsm)
# Plot the tiles
tilesLayer(EuropeOsm)
# Plot countries
plot(nuts0.spdf, add=TRUE)
# Map tiles sources
mtext(text = "Map data © OpenStreetMap contributors, under CC BY SA.", 
      side = 1, adj = 0, cex = 0.7, font = 3)
}
}
\seealso{
\link{tilesLayer}
}

