% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{carto.pal}
\alias{carto.pal}
\title{Build Cartographic Palettes}
\usage{
carto.pal(pal1, n1, pal2 = NULL, n2 = NULL, middle = FALSE,
  transparency = FALSE)
}
\arguments{
\item{pal1}{name of the color gradiant (see Details).}

\item{n1}{number of colors (up to 20)}

\item{pal2}{name of the color gradiant (see Details).}

\item{n2}{number of colors (up to 20)}

\item{middle}{a logical value. If TRUE, a neutral color ("#F6F6F6", almost 
white) between 
two gradients is added.}

\item{transparency}{a logical value. If TRUE, contrasts are enhenced by 
adding an opacity variation.}
}
\value{
A vector of colors is returned.
}
\description{
Builds sequantial and diverging color palettes. 
Diververging color palettes can be dissymetric (different number of colors in 
each of the two gradients)
}
\details{
Available palettes are: "blue.pal", "orange.pal", "red.pal", 
"brown.pal", "green.pal", "purple.pal"
"pink.pal", "wine.pal", "grey.pal", "turquoise.pal", "sand.pal", "taupe.pal", 
"kaki.pal" , "harmo.pal".
}
\note{
Use \link{display.carto.all} to show all palettes and use 
\link{display.carto.pal} to show one palette.
}
\examples{
# Simple gradient: blue
carto.pal(pal1 = "blue.pal" ,n1 = 20)

# Double gradient: blue & red
carto.pal(pal1 = "blue.pal", n1 = 10, pal2 = "red.pal", n2 = 10)

# Adding a neutral color
carto.pal(pal1 = "blue.pal", n1 = 10, pal2 = "red.pal", n2 = 10, middle = TRUE)

# Enhancing contrasts with transparency
carto.pal(pal1="blue.pal", n1 = 10, pal2 = "red.pal", n2 = 10, middle = TRUE,
          transparency = TRUE)

# The double gradient can be asymetric
carto.pal(pal1 = "blue.pal", n1 = 5, pal2 = "red.pal", n2 = 15, middle = TRUE,
          transparency = TRUE)

# Build and display a palette
mypal <- carto.pal(pal1 = "blue.pal", n1 = 5, pal2 = "red.pal", n2 = 15,
                   middle = TRUE, transparency = TRUE)
k <- length(mypal)
image(1:k, 1, as.matrix(1:k), col =mypal, xlab = paste(k," classes",sep=""),
      ylab = "", xaxt = "n", yaxt = "n",bty = "n")
}
\seealso{
\link{display.carto.pal}, \link{display.carto.all}
}

