% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretization.R
\name{discretization}
\alias{discretization}
\title{Discretization}
\usage{
discretization(v, nclass = NULL, method = "quantile")
}
\arguments{
\item{v}{a vector of numeric values.}

\item{nclass}{a number of classes}

\item{method}{a discretization method; one of "sd", "equal", 
"quantile", "jenks","q6" or "geom"  (see Details).}
}
\value{
A numeric vector of breaks
}
\description{
Discretization function.
}
\details{
"sd", "equal", "quantile" and "jenks" are \link{classIntervals} methods. The "q6" method
uses the following \link{quantile} probabilities: 0, 0.05, 0.275, 0.5, 0.725, 0.95, 1.   
The "geom" method is based on a geometric progression along the variable values.
}
\note{
This function is mainly a wrapper around classIntervals function of 
the classInt package + q6 and geom methods.
}
\examples{
# Create the natality rate
var <- nuts2.df$birth_2008/nuts2.df$pop2008 * 1000

# Histogram
hist(var, probability = TRUE, nclass = 30)
rug(var)
moy <- mean(var)
med <- median(var)
abline(v = moy, col = "red", lwd = 3)
abline(v = med, col = "blue", lwd = 3)

# Quantile intervals
breaks <- discretization(v = var, nclass = 6, method = "quantile")
hist(var, probability = TRUE, breaks = breaks, col = "#F0D9F9")
rug(var)
moy <- mean(var)
med <- median(var)
abline(v = moy, col = "red", lwd = 3)
abline(v = med, col = "blue", lwd = 3)

# Geometric intervals
breaks <- discretization(v = var, nclass = 8, method = "geom")
hist(var, probability = TRUE, breaks = breaks, col = "#F0D9F9")
rug(var)
moy <- mean(var)
med <- median(var)
abline(v = moy, col = "red", lwd = 3)
abline(v = med, col = "blue", lwd = 3)
}

