% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legends.R
\name{legendPropLines}
\alias{legendPropLines}
\title{Legend for Proportional Lines Maps}
\usage{
legendPropLines(pos = "topleft", title.txt = "Title of the legend",
  title.cex = 0.8, cex = 1, values.cex = 0.6, var, lwd, col = "red",
  frame = FALSE, values.rnd = 0)
}
\arguments{
\item{pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)).}

\item{title.txt}{title of the legend.}

\item{title.cex}{size of the legend title.}

\item{cex}{size of the legend. 2 means two times bigger.}

\item{values.cex}{size of the values in the legend.}

\item{var}{vector of values (at least min and max).}

\item{lwd}{width of the larger line.}

\item{col}{color of symbols.}

\item{frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{values.rnd}{number of decimal places of the values in 
the legend.}
}
\description{
Plot legend for proportional lines maps
}
\examples{
library(sp)
data("nuts2006")
plot(nuts0.spdf)
box()
legendPropLines(pos = "topleft", title.txt = "Title",
                title.cex = 0.8, values.cex = 0.6, cex = 1,
                var = c(min(nuts1.df$pop2008),max(nuts1.df$pop2008)),
                lwd = 15,
                col="red", frame=TRUE, values.rnd=0)
}
