% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipper.R
\name{zipper}
\alias{zipper}
\title{The \code{zipper} function can be used to simulate interaction among three vehicles in car following
on a single lane or three vehicles merging on a two-lane highway.}
\usage{
zipper(tstart, tend,
    ustart1, uend1, xstart1, xend1,
    ustart2, uend2, xstart2, xend2,
    ustart3, uend3, xstart3, xend3)
}
\arguments{
\item{tstart}{start time, a number}

\item{tend}{end time, a number}

\item{ustart1}{start speed (mph) for vehicle in lane 1, a number}

\item{uend1}{end speed (mph) for vehicle in lane 1, a number}

\item{xstart1}{start location for vehicle in lane 1 (feet), a number}

\item{xend1}{end location for vehicle in lane 1 (feet), a number}

\item{ustart2}{start speed (mph) for vehicle in lane 2, a number}

\item{uend2}{end speed (mph) for vehicle in lane 2, a number}

\item{xstart2}{start location for vehicle in lane 2 (feet), a number}

\item{xend2}{end location for vehicle in lane 2 (feet), a number}

\item{ustart3}{start speed (mph) for vehicle in lane 3, a number}

\item{uend3}{end speed (mph) for vehicle in lane 3, a number}

\item{xstart3}{start location for vehicle in lane 3 (feet), a number}

\item{xend3}{end location for vehicle in lane 3 (feet), a number}
}
\value{
\code{zipper} uses a deterministic model and animation to illustrate an ``idealistic'' situation,
a so-called a ``zipper merge.''
}
\description{
The \code{zipper} function can be used to simulate interaction among three vehicles in car following
on a single lane or three vehicles merging on a two-lane highway.
}
\examples{
zipper(0,60,90,90,0,5000,90,90,-200,4500,90,90,-500, 4000)
zipper(0,40,85,90,0,4000,90,99,0,4500,90,90,-500, 4200)
zipper(0,5,60,20,0,500,65,20,-100,467,80,20,-350,433)
}
