% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cenTS.R
\name{cenTS}
\alias{cenTS}
\title{Create a censored time series object of \code{cenTS} class}
\usage{
cenTS(value, order.by, lcl = NULL, ucl = NULL, ci = NULL,
  value.name = "value", ...)
}
\arguments{
\item{value}{the value vector.}

\item{order.by}{the index vector, must be a vector of time/date.}

\item{lcl}{the vector of lower censoring limits, or a single numeric representing the constant limit.
Default = \code{NULL} indicating no lower limit.}

\item{ucl}{the vector of upper censoring limits, or a single numeric representing the constant limit.
Default = \code{NULL} indicating no upper limit.}

\item{ci}{the vector of censoring indicators whose value is -1 (0, 1)
if the corresponding response is left censored  (observed, right censored).
Default = \code{NULL}, in which case, the function will compute \code{ci} by \code{value}, \code{lcl}
and \code{ucl}. If \code{ci} is not \code{NULL}, the function will check the consistency of the data,
assuming the observed values less (greater) than or equal to left (right) censoring limits are censored,
and are observed otherwise. The function will stop if inconsistent results are found.}

\item{value.name}{the name of the value, default = "value".}

\item{...}{additional variables, must be able to be coerced to a \code{data.frame}.}
}
\value{
a \code{cenTS} object, any censored observation will be replaced by its corresponding censoring limit.
}
\description{
Create a censored time series response object of \code{cenTS} class. Default name of the response is "value",
 with the vectors of lower/upper censoring limits denoted by \code{lcl} and \code{ucl} respectively.
 The vector of censoring indicators, i.e., \code{ci}, is part of the \code{cenTS} object.
 Additional related variables can be stored and provided in the construction function, whose names
 are stored in \code{xreg}. All variable values are assumed to be of the same length of and thus
 aligned with the censored response time series. \code{cenTS} inherits from \link[xts]{xts}.
}
\examples{
strDates <- c("2000-01-01", "2000-01-02", "2000-01-03", "2000-01-04", "2000-01-05")
ts <- cenTS(value=c(1,-2,1,NA,0),
            order.by=as.Date(strDates,"\%Y-\%m-\%d"),
            lcl=c(-3,-2,-1,-1,0),
            ucl=c(3,2,1,1,1),
            x=c(1,1,1,1,1),
            y=c(2,2,2,2,2))
 print(ts)
 print(xreg(ts))
 plot(ts)

\dontrun{
#wrong call, case 1
ts <- cenTS(value=c(1,-2,1,NA,0),
           order.by=as.Date(strDates,"\%Y-\%m-\%d"),
           lcl=c(-3,-2,-1,-1,0),
           ucl=c(3,2,1,1,1),
           ci =c(-1,-1,1,NA,-1)
)
#wrong call, case 2
ts <- cenTS(value=c(1,-2,1,NA,0),
           order.by=as.Date(strDates,"\%Y-\%m-\%d"),
           lcl=c(-3,-2,-1,-1,0),
           ucl=c(3,2,1,1,1),
           ci =c(1,-1,1,NA,-1)
)


#wrong call, case 3
ts <- cenTS(value=c(1,-2,1,NA,0),
           order.by=as.Date(strDates,"\%Y-\%m-\%d"),
           lcl=c(-3,-2,-1,-1,0),
           ucl=c(3,2,1,1,1),
           ci =c(0,-1,0,NA,-1)
)
}

}

