% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cenTS.R
\name{plot.cenTS}
\alias{plot.cenTS}
\title{Plot a \code{cenTS} object}
\usage{
\method{plot}{cenTS}(x, type = "l", auto.grid = TRUE,
  major.ticks = "auto", minor.ticks = TRUE, major.format = TRUE,
  bar.col = "grey", candle.col = "white", ann = TRUE, axes = TRUE,
  ylim = NULL, main = NULL, ...)
}
\arguments{
\item{x}{a \code{cenTS} object.}

\item{type, auto.grid, major.ticks, minor.ticks, major.format, bar.col, candle.col, ann, axes, ylim, main, ...}{standard parameters to control the plot.}
}
\description{
Plot a \code{cenTS} object
}
\examples{
strDates <- c("2000-01-01", "2000-01-02", "2000-01-03", "2000-01-04", "2000-01-05")
ts <- cenTS(value=c(1,-2,1,NA,0),
            order.by=as.Date(strDates,"\%Y-\%m-\%d"),
            lcl=c(-3,-2,-1,-1,0),
            ucl=c(3,2,1,1,1),
            x=c(1,1,1,1,1),
            y=c(2,2,2,2,2))
 plot(ts)
}
\seealso{
\code{\link[xts]{plot.xts}}.
}
