% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Copula.R
\docType{class}
\name{CopulaObj-class}
\alias{CopulaObj-class}
\title{An S4 class to represent a copula object to model the correlation.}
\description{
An S4 class to represent a copula object to model the correlation.
}
\section{Slots}{

\describe{
\item{\code{type}}{The type of the copula object.}

\item{\code{para}}{A numeric vector that contains copula parameter(s).}

\item{\code{marginal}}{A list of Distribution objects.}

\item{\code{dispstr}}{The format of symmetric positive definite matrix used by elliptical copula (Normal Copula, t Copula). The default is "un" for unstructured. Other choices include "ex" for exchangeable, "ar1" for AR(1), and "toep" for Toeplitz (toeplitz).}

\item{\code{df}}{The number of degrees of freedom used in t Copula.}

\item{\code{observation}}{A matrix that contains the experience data for copula fitting.}

\item{\code{fitmethod}}{The method of copula fitting. Default is "mpl":maximum pseudo-likelihood estimator. Others include "ml": maximum likelihood assuming it is the true distribution; "itau": inversion of Kendall’s tau estimator; "irho": inversion of Spearman’s rho estimator.}

\item{\code{fittest}}{Whether to run goodness of fit test for copula fitting. Goodness of fit test could take a long time to finish.}

\item{\code{fitsucc}}{Whether a copula fitting is successful.}

\item{\code{coutput}}{Goodness of fit results.}

\item{\code{info}}{A character string that contains additional information of the copula to identify line/type/frequency/time lag/severity.}
}}

