% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitDist.R
\docType{class}
\name{FitDist-class}
\alias{FitDist-class}
\title{An S4 class to represent distribution fitting.}
\description{
An S4 class to represent distribution fitting.
}
\section{Slots}{

\describe{
\item{\code{observation}}{Raw data input containing loss sizes for severity analysis and number of losses for frequency analysis.}

\item{\code{fitdata}}{Processed data for distribution fitting. Frequency data may be provided as occurrence dates. The class will transform them into frequency data before distribution fitting.}

\item{\code{trend}}{Index object for detrending the data.}

\item{\code{startDate}}{Start date of claim data used for distribution fitting. The trend Index should also start from the same date (year-month).}

\item{\code{endDate}}{End date of claim data used for distribution fitting.}

\item{\code{trail}}{Trial Distribution object to start fitting.}

\item{\code{fitted}}{Fitted Distribution object.}

\item{\code{reportLag}}{Report lag distribution to adjust frequency data.}

\item{\code{iLag}}{Whether to adjust the frequency data with report lag distribution.}

\item{\code{method}}{Distribution fitting method. Maximum likelihood estimation (mle), moment matching estimation(mme) and quantile matching estimation(qme) are available.}

\item{\code{probs}}{A vector containing the percentiles to be matched if qme is used for fitting.}

\item{\code{ifreq}}{A boolean indicating whether it is frequency data or severity data.}

\item{\code{idate}}{A boolean indicating whether frequency data is provided as occurrence dates (TRUE) or number of occurrences (FALSE).}

\item{\code{datelist}}{A vector containing occurrence dates. It could be a data field in a claim file.}

\item{\code{freq}}{A character string indicating the frequency: "Annual" or "Monthly".}

\item{\code{iDL}}{A boolean indicating whether deductible and limit is considered in distribution fitting.}

\item{\code{limit}}{A vector containing the limit for each claim.}

\item{\code{deductible}}{A vector containing the deductible for each claim.}

\item{\code{p0}}{A number that is the probability of having a zero-amount claim after deductible.}

\item{\code{dof}}{Degree of freedom.}

\item{\code{psd}}{A vector containing the standard deviation of parameter estimation. It is only available for mle.}

\item{\code{aic}}{Akaike information criterion.}

\item{\code{bic}}{Bayesian information criterion.}

\item{\code{chisq}}{Chi-Squared Test Statistic.}

\item{\code{pchisq}}{p-value of Chi-Squared Test.}

\item{\code{kstest}}{K-S Test Statistic. Only used for continuous distribution.}

\item{\code{pkstest}}{p-value of K-S Test. Only used for continuous distribution.}

\item{\code{soutput}}{Distribution fitting summary.}
}}

