% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonize_factors.R
\name{armonizar_rama}
\alias{armonizar_rama}
\title{Armoniza los codigos de rama ocupacional}
\usage{
armonizar_rama(d)
}
\arguments{
\item{d}{una encuesta CASEN en formato tibble o data.frame}
}
\value{
un tibble con la columna de rama transformada
}
\description{
Convierte las etiquetas de la rama ocupacional para usar de 
manera uniforme los nombres de CASEN 2017, debiendo fusionar algunas
categorias que se intersectan (ejemplo: "Establecimientos Financieros" y
"Servicios de Gobierno y Financieros").
El procedimiento consiste en buscar la columna \code{rama} (antes del anio 
2011) o \code{rama1} (desde el anio 2011) y aplicar expresiones regulares 
de acuerdo a la codificacion respectiva.
}
\examples{
\dontrun{
casen1990 <- readRDS("casen1990.rds")
armonizar_rama(casen1990)
}
}
