% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat2cat_utils.R
\name{dummy_c2c}
\alias{dummy_c2c}
\title{Add default cat2cat columns to a `data.frame`}
\usage{
dummy_c2c(df, cat_var, ml = NULL)
}
\arguments{
\item{df}{`data.frame`.}

\item{cat_var}{`character(1)` a categorical variable name.}

\item{ml}{`character` vector of ml models applied,
any of `c("knn", "rf", "lda")`.}
}
\value{
the provided `data.frame` with additional `cat2cat` like columns.
}
\description{
a utils function to add default cat2cat columns
to a `data.frame`.
It will be useful e.g. for a boarder periods which will not have additional
 `cat2cat` columns.
}
\examples{
\dontrun{
dummy_c2c(airquality, "Month")

data("occup_small", package = "cat2cat")
occup_old <- occup_small[occup_small$year == 2008, ]
dummy_c2c(occup_old, "code")
dummy_c2c(occup_old, "code", "knn")
}
}
