% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{d1LL}
\alias{d1LL}
\title{The First Derivative of the Log-Likelihood}
\usage{
d1LL(catObj, theta, use_prior)
}
\arguments{
\item{catObj}{An object of class \code{Cat}}

\item{theta}{A numeric or an integer indicating the value for \eqn{\theta_j}}

\item{use_prior}{A logical indicating whether to calculate based on the log-likelihood or log-posterior}
}
\value{
The function \code{d1LL} returns a numeric of the derivative of the log-likelihood (or log-posterior) given a respondent's answer profile.
}
\description{
Calculates either the first derivative of the log-likelihood or the first derivative
of the log-posterior evaluated at point \eqn{\theta}.
}
\details{
When the \code{usePrior} argument is \code{FALSE}, the function \code{d1LL} evaluates the first derivative of the log-likelihood at point \eqn{\theta}.  

When the \code{usePrior} argument is \code{TRUE}, the function \code{d1LL} evaluates the first derivative of the log-posterior at point \eqn{\theta}. 

If the argument \code{use_prior} is \code{TRUE}, the function \code{d1LL} must use the the normal prior distribution.
}
\note{
This function is to allow users to access the internal functions of the package. During item selection, all calculations are done in compiled \code{C++} code.
}
\examples{
## Loading ltm Cat object
data(ltm_cat)

## Store example answers
setAnswers(ltm_cat) <- c(1,0,1,0,1, rep(NA, 35))

## d1LL for Cat object of the ltm model
d1LL(ltm_cat, theta = 1, use_prior = FALSE)


}
\references{
Baker, Frank B. and Seock-Ho Kim. 2004. Item Response Theory: Parameter Estimation Techniques. New York: Marcel Dekker.

Choi, Seung W. and Richard J. Swartz. 2009. ``Comparison of CAT Item Selection Criteria for Polytomous Items." Applied Psychological Measurement 33(6):419-440.

Muraki, Eiji. 1992. ``A generalized partial credit model: Application of an EM algorithm." ETS Research Report Series 1992(1):1-30.

van der Linden, Wim J. 1998. ``Bayesian Item Selection Criteria for Adaptive Testing." Psychometrika 63(2):201-216.
}
\seealso{
\code{\link{Cat-class}}, \code{\link{prior}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery,
 Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
