% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cata.R
\encoding{UTF-8}
\name{inspect}
\alias{inspect}
\title{Inspect/summarize many b-cluster analysis runs}
\usage{
inspect(X, G = 2, bestB = NULL, bestM = NULL, inspect.plot = TRUE)
}
\arguments{
\item{X}{three-way array; the \code{I, J, M} array has \code{I}
assessors, \code{J} products, \code{M} attributes where CATA data have values 
\code{0} (not checked) and \code{1} (checked)}

\item{G}{number of clusters (required for non-hierarchical algorithm)}

\item{bestB}{total sensory differentiation retained in the best solution. If
not provided, then \code{bestB} is determined from best solution in the runs
provided (in \code{X}).}

\item{bestM}{cluster memberships for best solution. If not provided, then 
the best solution is determined from the runs provided (in \code{X}).}

\item{inspect.plot}{default (\code{TRUE}) plots results from the 
\code{\link[cata]{inspect}} function}
}
\value{
A data frame with unique solutions in rows and the following
columns:
\itemize{
\item{\code{B} : Sensory differentiation retained}
\item{\code{pctB} : Percentage of the total sensory differentiation retained}
\item{\code{B.prop} : Proportion of sensory differentiation retained compared
to best solution}
\item{\code{raw.agree} : raw agreement with best solution}
\item{\code{count} : number of runs for which this solution was observed} 
\item{\code{c.1, c.2, ...} : remaining columns gives index of the cluster 
to which the consumers (columns) are allocated}}
}
\description{
Inspect many runs of b-cluster analysis. Calculate sensory differentiation 
retained and recurrence rate.
}
\examples{
data(bread)

res <- bcluster.n(bread$cata[1:8, , 1:5], G = 2, runs = 3)
inspect(res)
}
\references{
Castura, J.C., Meyners, M., Varela, P., & Næs, T. (2022). 
Clustering consumers based on product discrimination in check-all-that-apply 
(CATA) data. \emph{Food Quality and Preference}, 104564. 
\doi{10.1016/j.foodqual.2022.104564}.
}
