% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cate.R, R/factor_functions.R
\name{est.confounder.num}
\alias{est.confounder.num}
\alias{est.factor.num}
\title{Estimate the number of confounders}
\usage{
est.confounder.num(X, Y, X.nuis = NULL, method = c("ED", "BCV"),
  rmax = 20, nRepeat = 12, bcv.plot = TRUE, log = "")

est.factor.num(Y, method = c("ED", "BCV"), rmax = 20, nRepeat = 12,
  bcv.plot = TRUE, log = "")
}
\arguments{
\item{X}{treatment variable, n*d0 matrix}

\item{Y}{outcome, n*p matrix}

\item{X.nuis}{nuissance covarites, n*d1 matrix}

\item{method}{method to estimate the number of factors. There are currently two choices,
"ED" is the eigenvalue difference method proposed by Onatski (2010) and "BCV" is the
bi-cross-validation method proposed by Owen and Wang (2015). "BCV" tends to estimate more
weak factors and takes longer time}

\item{rmax}{the maximum number of factors to consider. If the estimated number of factors is rmax,
then users are encouraged to increase rmax and run again. Default is 20.}

\item{nRepeat}{the number of repeats of bi-cross-validation. A larger nRepeat will result in a
more accurate estimate of the BCV error, but will need longer time to run.}

\item{bcv.plot}{whether to plot the relative BCV error versus the number of estimated
ranks. The relative BCV error is the entrywise mean square error devided by the average of
the estimated noise variance.}

\item{log}{if \code{log = "y"}, then the y-axis of the BCV plot is in log scale.}
}
\value{
if \code{method} is "ED", then return the estimated number of confounders/factors.
If \code{method} is "BCV", then return the a list of objects
\describe{
\item{r}{estimated number of confounders/factors}
\item{errors}{the relative BCV errors of length \code{1 + rmax}}
}
}
\description{
Estimate the number of confounders
}
\section{Functions}{
\itemize{
\item \code{est.factor.num}: Estimate the number of factors
}}
\examples{
## example for est.confounder.num
data <- gen.sim.data(n = 50, p = 100, r = 5)
est.confounder.num(data$X1, data$Y, data$X0, method = "ED")
est.confounder.num(data$X1, data$Y, data$X0, method = "BCV")
## example for est.factor.num
n <- 50
p <- 100
r <- 5
Z <- matrix(rnorm(n * r), n, r)
Gamma <- matrix(rnorm(p * r), p, r)
Y <- Z \%*\% t(Gamma) + rnorm(n * p)

est.factor.num(Y, method = "ED")
est.factor.num(Y, method = "BCV")
}
\references{
{
A. B. Owen and J. Wang (2015), Bi-cross-validation for factor analysis. \emph{arXiv:1503.03515}.

A. Onatski (2010), Determining the number of factors from empirical distribution of eigenvalues.
\emph{The Review of Economics and Statistics} 92(4).
}
}

