% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitCauchy.R
\name{print.cauphyfit}
\alias{print.cauphyfit}
\alias{vcov.cauphyfit}
\alias{logLik.cauphyfit}
\alias{AIC.logLik.cauphyfit}
\alias{AIC.cauphyfit}
\alias{confint.cauphyfit}
\alias{coef.cauphyfit}
\title{Generic Methods for S3 class \code{cauphyfit}.}
\usage{
\method{print}{cauphyfit}(x, digits = max(3, getOption("digits") - 3), ...)

\method{vcov}{cauphyfit}(object, ...)

\method{logLik}{cauphyfit}(object, ...)

\method{AIC}{logLik.cauphyfit}(object, k = 2, ...)

\method{AIC}{cauphyfit}(object, k = 2, ...)

\method{confint}{cauphyfit}(object, parm, level = 0.95, ...)

\method{coef}{cauphyfit}(object, ...)
}
\arguments{
\item{x}{an object of class \code{"phylolm"}.}

\item{digits}{number of digits to show in summary method.}

\item{...}{further arguments to methods.}

\item{object}{an object of class \code{cauphyfit}.}

\item{k}{numeric, the penalty per parameter to be used; the default \code{k = 2} is the classical AIC.}

\item{parm}{a specification of which parameters are to be given confidence intervals, either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{the confidence level required.}
}
\value{
Same value as the associated methods from the \code{stats} package:
\itemize{
\item{\code{\link[stats]{vcov}}}{ an estimated covariance matrix, see \code{\link{compute_vcov}};}
\item{\code{\link[stats]{logLik}}}{ an object of class \code{\link[stats]{logLik}};}
\item{\code{\link[stats]{AIC}}}{ a numeric value;}
\item{\code{\link[stats]{confint}}}{ a matrix (or vector) with columns giving lower and upper confidence limits for each parameter;}
\item{\code{\link[stats]{coef}}}{ coefficients extracted from the model;}
}
}
\description{
Generic Methods for S3 class \code{cauphyfit}.
}
\examples{
# Simulate tree and data
set.seed(1289)
phy <- ape::rphylo(20, 0.1, 0)
dat <- rTraitCauchy(n = 1, phy = phy, model = "cauchy",
                    parameters = list(root.value = 10, disp = 0.1))
# Fit the data
fit <- fitCauchy(phy, dat, model = "cauchy", method = "reml")
fit
# vcov matrix
vcov(fit)
# Approximate confidence intervals
confint(fit)
# log likelihood of the fitted object
logLik(fit)
# AIC of the fitted object
AIC(fit)
# coefficients
coef(fit)

}
\seealso{
\code{\link{fitCauchy}}, \code{\link[stats]{vcov}}, \code{\link[stats]{logLik}}
\code{\link[stats]{AIC}}, \code{\link[stats]{confint}}, \code{\link[stats]{coef}},
\code{\link[stats]{predict}}, \code{\link[phylolm]{predict.phylolm}}
}
