% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cauphylm.R
\name{print.cauphylm}
\alias{print.cauphylm}
\alias{vcov.cauphylm}
\alias{logLik.cauphylm}
\alias{AIC.logLik.cauphylm}
\alias{AIC.cauphylm}
\alias{predict.cauphylm}
\alias{confint.cauphylm}
\alias{coef.cauphylm}
\title{Generic Methods for S3 class \code{cauphylm}.}
\usage{
\method{print}{cauphylm}(x, digits = max(3, getOption("digits") - 3), ...)

\method{vcov}{cauphylm}(object, ...)

\method{logLik}{cauphylm}(object, ...)

\method{AIC}{logLik.cauphylm}(object, k = 2, ...)

\method{AIC}{cauphylm}(object, k = 2, ...)

\method{predict}{cauphylm}(object, newdata = NULL, ...)

\method{confint}{cauphylm}(object, parm, level = 0.95, ...)

\method{coef}{cauphylm}(object, ...)
}
\arguments{
\item{x}{an object of class \code{"phylolm"}.}

\item{digits}{number of digits to show in summary method.}

\item{...}{further arguments to methods.}

\item{object}{an object of class \code{cauphylm}.}

\item{k}{numeric, the penalty per parameter to be used; the default \code{k = 2} is the classical AIC.}

\item{newdata}{an optional data frame to provide the predictor values
  at which predictions should be made. If omitted, the fitted values are used. Currently, predictions are made for new species whose placement in the tree is unknown. Only their covariate information is used. The prediction for the trend model is not currently implemented.}

\item{parm}{a specification of which parameters are to be given confidence intervals, either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{the confidence level required.}
}
\value{
Same value as the associated methods from the \code{stats} package:
\describe{
\item{\code{\link[stats]{vcov}}}{ an estimated covariance matrix, see \code{\link{compute_vcov}};}
\item{\code{\link[stats]{logLik}}}{ an object of class \code{\link[stats]{logLik}};}
\item{\code{\link[stats]{AIC}}}{ a numeric value;}
\item{\code{\link[stats]{confint}}}{ a matrix (or vector) with columns giving lower and upper confidence limits for each parameter;}
\item{\code{\link[stats]{coef}}}{ coefficients extracted from the model;}
\item{\code{\link[stats]{predict}}}{ a vector of predicted values.}
}
}
\description{
Generic Methods for S3 class \code{cauphylm}.
}
\examples{
# Simulate tree and data
set.seed(1289)
phy <- ape::rphylo(20, 0.1, 0)
error <- rTraitCauchy(n = 1, phy = phy, model = "cauchy",
                      parameters = list(root.value = 0, disp = 0.1))
x1 <- ape::rTraitCont(phy, model = "BM", sigma = 0.1, root.value = 0)
trait <- 3 + 2*x1 + error
# Fit the data
fit <- cauphylm(trait ~ x1, phy = phy)
fit
# vcov matrix
vcov(fit)
# Approximate confidence intervals
confint(fit)
# log likelihood of the fitted object
logLik(fit)
# AIC of the fitted object
AIC(fit)
# predicted values
predict(fit)
# coefficients
coef(fit)

}
\seealso{
\code{\link{cauphylm}}, \code{\link[stats]{vcov}}, \code{\link[stats]{logLik}}
\code{\link[stats]{AIC}}, \code{\link[stats]{confint}}, \code{\link[stats]{coef}},
\code{\link[stats]{predict}}, \code{\link[phylolm]{predict.phylolm}}
}
