% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replaceLabels.R
\name{replaceLabels}
\alias{replaceLabels}
\title{Replace parameter labels in a \code{mcmc.list} with more meaningful labels after they are created by running \code{dag_greta()}.  When \code{greta} creates posterior distributions for multi-dimensional parameters, it creates an often meaningless number system for the parameter (e.g. beta[1,1], beta[2,1], etc.).  Since parameter dimensionality is often determined by a \code{factor}, this functionality restores the text labels associated with the underlying factor whose coefficients are being estimated (e.g. beta_varValue1, beta_varValue2).  The meaningful parameter names are stored in an environment, \code{cacheEnv}, created by a call to \code{dag_greta()}.}
\usage{
replaceLabels(draws)
}
\arguments{
\item{draws}{an \code{mcmc.list} object created by  \code{dag_greta()}.}
}
\value{
an \code{mcmc.list} with more meanignful names that get created during a \code{dag_greta} function call.
}
\description{
Replace parameter labels in a \code{mcmc.list} with more meaningful labels after they are created by running \code{dag_greta()}.  When \code{greta} creates posterior distributions for multi-dimensional parameters, it creates an often meaningless number system for the parameter (e.g. beta[1,1], beta[2,1], etc.).  Since parameter dimensionality is often determined by a \code{factor}, this functionality restores the text labels associated with the underlying factor whose coefficients are being estimated (e.g. beta_varValue1, beta_varValue2).  The meaningful parameter names are stored in an environment, \code{cacheEnv}, created by a call to \code{dag_greta()}.
}
