% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outcome_models.R
\name{confint.causalEffect}
\alias{confint.causalEffect}
\title{Confidence Intervals for Causal Effects}
\usage{
\method{confint}{causalEffect}(
  object,
  parm,
  level = 0.95,
  method = c("asymptotic", "bootstrap", "jackknife"),
  ...
)
}
\arguments{
\item{object}{An object of class \link[=causalEffect-class]{causalEffect}}

\item{parm}{Unused. Included to match forms of other \code{confint} functions}

\item{level}{Confidence level. Should be between 0 and 1. Default is 0.95.}

\item{method}{How to calculate the confidence interval. Choices are "bootstrap" for
a bootstrap confidence interval, "asymptotic" for "asymptotic" confidence intervals, and
"jacknife" for jacknife confidence intervals. Default is "asymptotic" since it is faster.}

\item{...}{Additional arguments if method is "bootstrap". Can include
\itemize{
\item \code{n.boot}. How many bootstrap samples should be used. Default is 1000.
\item \code{boot.method}. One of "n-out-of-n" or "m-out-of-n". Optimal transport methods default to
"m-out-of-n".
\item \code{verbose}. Should a progress bar be printed? (TRUE/FALSE) Defaults to FALSE.
}}
}
\value{
A list with slots "CI" giving the confidence bounds and "SD" giving estimates of the standard
error of the causal effects. If method is "bootstrap" and \code{boot.method} is "m-out-of-n", then there will
also be a slot named "unadjusted" giving the unadjusted confidence interval and standard error estimate
for reference.
}
\description{
Confidence Intervals for Causal Effects
}
\examples{
# set-up data
set.seed(1234)
data <- Hainmueller$new()
data$gen_data()

# calculate quantities
weight <- calc_weight(data, method = "Logistic")
tx_eff <- estimate_effect(data = data, weights = weight)

# get asymptotic C.I.
confint(tx_eff, model = "lm", method = "asymptotic",
    formula = list(treated = "y ~ .", control = "y ~ ."))
}
