% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{plot.causalWeights}
\alias{plot.causalWeights}
\title{plot.causalWeights}
\usage{
\method{plot}{causalWeights}(
  x,
  r_eff = NULL,
  penalty,
  p = 2,
  cost = NULL,
  debias = TRUE,
  online.cost = "auto",
  diameter = NULL,
  niter = 1000,
  tol = 1e-07,
  ...
)
}
\arguments{
\item{x}{A \linkS4class{causalWeights} object}

\item{r_eff}{The \eqn{r_\text{eff}} to use for the \code{\link[=PSIS_diag]{PSIS_diag()}} function.}

\item{penalty}{The penalty of the optimal transport distance to use. If missing or NULL, the function will try to guess a suitable value depending if debias is TRUE or FALSE.}

\item{p}{\eqn{L_p} distance metric power}

\item{cost}{Supply your own cost function. Should take arguments \code{x1}, \code{x2}, and \code{p}.}

\item{debias}{TRUE or FALSE. Should the debiased optimal transport distances be used.}

\item{online.cost}{How to calculate the distance matrix. One of "auto", "tensorized", or "online".}

\item{diameter}{The diameter of the metric space, if known. Default is NULL.}

\item{niter}{The maximum number of iterations for the Sinkhorn updates}

\item{tol}{The tolerance for convergence}

\item{...}{Not used at this time}
}
\value{
The plot method returns an invisible object of class summary_causalWeights.
}
\description{
plot.causalWeights
}
\details{
The plot method first calls summary.causalWeights on the causalWeights object. Then plots the diagnostics from that summary object.
}
\seealso{
\code{\link[=summary.causalWeights]{summary.causalWeights()}}
}
