% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barycentricProjection.R
\name{predict.bp}
\alias{predict.bp}
\title{Predict method for barycentric projection models}
\usage{
\method{predict}{bp}(
  object,
  newdata = NULL,
  source.sample,
  cost_function = NULL,
  niter = 1000,
  tol = 1e-07,
  ...
)
}
\arguments{
\item{object}{An object of class "bp"}

\item{newdata}{a data.frame containing new observations}

\item{source.sample}{a vector giving the sample each observations arise from}

\item{cost_function}{a cost metric between observations}

\item{niter}{number of iterations to run the barycentric projection for powers > 2.}

\item{tol}{Tolerance on the optimization problem for projections with powers > 2.}

\item{...}{Dots passed to the lbfgs method in the torch package.}
}
\description{
Predict method for barycentric projection models
}
\examples{
if(torch::torch_is_installed()) {
set.seed(23483)
n <- 2^5
pp <- 6
overlap <- "low"
design <- "A"
estimate <- "ATT"
power <- 2
data <- causalOT::Hainmueller$new(n = n, p = pp,
design = design, overlap = overlap)

data$gen_data()

weights <- causalOT::calc_weight(x = data,
  z = NULL, y = NULL,
  estimand = estimate,
  method = "NNM")
  
 df <- data.frame(y = data$get_y(), z = data$get_z(), data$get_x())
  
 # undebiased
 fit <- causalOT::barycentric_projection(y ~ ., data = df, 
    weight = weights,
    separate.samples.on = "z", niter = 2)
    
 #debiased
 fit_d <- causalOT::barycentric_projection(y ~ ., data = df, 
    weight = weights,
    separate.samples.on = "z", debias = TRUE, niter = 2)
 
 # predictions, without new data
 undebiased_predictions <- predict(fit,   source.sample = df$z)
 debiased_predictions   <- predict(fit_d, source.sample = df$z)
 
 isTRUE(all.equal(unname(undebiased_predictions), df$y)) # FALSE
 isTRUE(all.equal(unname(debiased_predictions), df$y)) # TRUE
 }
}
