% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_plays.R
\name{load_plays}
\alias{load_plays}
\title{Load cbb play by play data}
\usage{
load_plays(seasons = most_recent_season())
}
\arguments{
\item{seasons}{an integer or vector of integers of seasons to fetch data for. Defaults to the most recent season. Pass in \code{TRUE} to fetch all seasons.}
}
\value{
a dataframe of play-by-play data from all D1 college basketball games.
}
\description{
Grabs entire seasons of play-by-play data from the collegebasketballdata.com API for specified season(s)

Includes a roughly complete record of every tracked play in for the games in the specified seasons.

For many games with clean player substitution data, the identities of the players on the floor are included. Sometimes, substitution data is unclean, and this results in too many or too fewer players listed as being on the floor at a given time.

A primary player is identified for some plays as \verb{participants_*_1}. For example, in an unassisted shot, the ID of the player taking the shot is \code{participants_id_1}. If two players are involved in a play, the initiating player is listed as \code{participants_id_1} and the receiving player is listed as \code{participants_id_2}. If a player passes the ball to another player who makes a shot, the assisting player is listed as \code{participants_id_1} and the shooting player is listed as \code{participants_id_2}.

Shot location data is provided where available.

The win probability for the home team at the time of each play is provided as \code{win_probability}. These are predictions provided by the collegebasketballdata.com API, not built into the package.
}
\examples{
\donttest{
try({ # avoid cran errors
load_plays()
})
}

}
\seealso{
\url{https://john-b-edwards.github.io/cbbreadr/articles/dictionary_plays.html} for a web version of the data dictionary

\code{\link{dictionary_plays}} for the data dictionary as bundled within the package

Issues with this data should be filed here: \url{https://github.com/john-b-edwards/cbbd-data/issues}
}
