% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomics_by_study.R
\name{.get_data_by_study}
\alias{.get_data_by_study}
\title{Internal Function to Get Mutations/CNA/Fusion By Study ID}
\usage{
.get_data_by_study(
  study_id = NULL,
  molecular_profile_id = NULL,
  data_type = c("mutation", "cna", "fusion", "structural_variant"),
  base_url = NULL,
  add_hugo = TRUE
)
}
\arguments{
\item{study_id}{A study ID to query mutations. If NULL, guesses study ID based
on molecular_profile_id.}

\item{molecular_profile_id}{a molecular profile to query mutations.
If NULL, guesses molecular_profile_id based on study ID.}

\item{data_type}{specify what type of data to return. Options are\code{mutation}, \code{cna}, \code{fusion}, or \code{structural_variant} (same as \code{fusion}).}

\item{base_url}{The database URL to query
If \code{NULL} will default to URL set with \verb{set_cbioportal_db(<your_db>)}}

\item{add_hugo}{Logical indicating whether \code{HugoGeneSymbol} should be added to your resulting data frame, if not already present in raw API results.
Argument is \code{TRUE} by default. If \code{FALSE}, results will be returned as is (i.e. any existing Hugo Symbol columns in raw results will not be removed).}
}
\value{
a dataframe of mutations, CNAs or structural variants
}
\description{
Endpoints for retrieving mutation and cna data are structurally similar.
This internal function allows you to pull data from either endpoint. It has
logic for sensible default guesses at \code{study_id} and \code{molecular_profile_id} when those are \code{NULL}
}
\examples{
\dontrun{
set_cbioportal_db("public")
.get_data_by_study(study_id = "prad_msk_2019", data_type = "cna")
.get_data_by_study(study_id = "prad_msk_2019", data_type = "mutation")
.get_data_by_study(study_id = "prad_msk_2019", data_type = "fusion")

.get_data_by_study(molecular_profile_id = "prad_msk_2019_cna", data_type = "cna")
.get_data_by_study(molecular_profile_id = "prad_msk_2019_mutations", data_type = "mutation")
.get_data_by_study(molecular_profile_id = "prad_msk_2019_structural_variants", data_type = "fusion")
}

}
\keyword{internal}
