% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomics_by_study.R
\name{get_genetics_by_study}
\alias{get_genetics_by_study}
\title{Get All Genomic Information By Study}
\usage{
get_genetics_by_study(study_id = NULL, add_hugo = TRUE, base_url = NULL)
}
\arguments{
\item{study_id}{A study ID to query mutations. If NULL, guesses study ID based
on molecular_profile_id.}

\item{add_hugo}{Logical indicating whether \code{HugoGeneSymbol} should be added to your resulting data frame, if not already present in raw API results.
Argument is \code{TRUE} by default. If \code{FALSE}, results will be returned as is (i.e. any existing Hugo Symbol columns in raw results will not be removed).}

\item{base_url}{The database URL to query
If \code{NULL} will default to URL set with \verb{set_cbioportal_db(<your_db>)}}
}
\value{
A list of mutations, cna and structural variants (including fusions), if available.
}
\description{
Get All Genomic Information By Study
}
\examples{
\dontrun{
get_genetics_by_study(study_id = "prad_msk_2019")
}
}
