% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Checkw.r
\name{checkw}
\alias{checkw}
\title{Checking composite based SE models if there are weights in accordance with the loadings and the 
covariance matrix of the composites}
\usage{
checkw(B, indicatorx, indicatory, lambdax = FALSE, lambday = FALSE,
  wx = FALSE, wy = FALSE, Sxixi, R2 = NULL)
}
\arguments{
\item{B}{(q,q) lower triangular matrix describing the interrelations of the latent variables:
b_ij = 1 regression coefficient of eta_j in the regression relation in which eta_i 
         is the depend variable
b_ij = 0 if eta_i does not depend on eta_j in a direct way  (b_ii = 0 !)}

\item{indicatorx}{vector describing with which exogenous composite the X-variables are connected}

\item{indicatory}{vector describing with which endogenous composite the Y-variables are connected}

\item{lambdax}{vector of loadings  for the X-variables in the model or FALSE}

\item{lambday}{vector of loadings for the Y-variables in the model or FALSE}

\item{wx}{vector of weights  for the X-variables in the model or FALSE}

\item{wy}{vector of weights  for the Y-variables in the model or FALSE}

\item{Sxixi}{covariance matrix of exogenous composites}

\item{R2}{vector of coefficients of determination of structural regression equations}
}
\value{
out list with components
       \tabular{ll}{
         crit.value \tab vector of length 2 with the values of the optimisation criterion \cr
         wx \tab  vector of length p1 of weights for constructing the exogenous composites  \cr
         wy \tab  vector of length  p2 of weights for constructing the endogenous composites  \cr
        }
}
\description{
\code{checkw} determines if there are sets of weights fulfilling the critical relation for the 
covariance matricies of the composites.
}
\examples{
   
B <- matrix(c(0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,
              0,1,1,0,0,0,0,1,1,1,0,0,1,0,0,0,1,0),6,6,byrow=TRUE)
indicatorx <- c(1,1,1,1,1)
indicatory <- c(1, 1, 1, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5) 
lambdax <- c(0.73, 0.60, 0.60, 0.77, 0.74) 
lambday <- c(0.79, 0.68, 0.60, 0.90, 0.94, 0.80, 0.65, 0.78, 0.78, 0.74, 
                     0.77, 0.78, 0.80, 0.84, 0.85, 0.86, 0.23, 0.87) 
Sxixi <- matrix(1,1,1)
out <- checkw(B,indicatorx,indicatory,lambdax=TRUE,lambday=TRUE,wx=FALSE,wy=FALSE, Sxixi,R2=NULL)

}
