% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-data.R
\name{get_data-deprecated}
\alias{get_data-deprecated}
\alias{get_data}
\title{Get data from Statistics Netherlands (CBS)}
\usage{
get_data(id, ..., recode = TRUE, use_column_title = recode,
  dir = tempdir(), base_url = getOption("cbsodataR.base_url",
  BASE_URL))
}
\arguments{
\item{id}{Identifier of table, can be found in \code{\link[=cbs_get_toc]{cbs_get_toc()}}}

\item{...}{optional filter statements, see details.}

\item{recode}{recodes all codes in the code columns with their \code{Title} as found
in the metadata}

\item{use_column_title}{not used.}

\item{dir}{Directory where the table should be downloaded. Defaults to temporary
directory}

\item{base_url}{optionally specify a different server. Useful for
third party data services implementing the same protocol.}
}
\value{
\code{data.frame} with the requested data. Note that a csv copy of
the data is stored in \code{dir}.
}
\description{
This method is deprecated in favor of \code{\link[=cbs_get_data]{cbs_get_data()}}
}
\details{
To reduce the download time, optionaly the data can be filtered on category values:
for large tables (> 100k records) this is a wise thing to do.

The filter is specified with \code{<column_name> = <values>} in which \code{<values>} is a character vector.
Rows with values that are not part of the character vector are not returned. Note that the values
have to be raw (un-recoded) values.

By default the columns will be converted to their type (\code{typed=TRUE}).
CBS uses multiple types of missing (unknown, surpressed, not measured, missing): users
wanting all these nuances can use \code{typed=FALSE} which results in character columns.
}
\examples{
\dontrun{

# get data for main (000000) Consumer Price Index (7196ENG) for March 2000, 
 cbs_get_data( id      = "7196ENG"      # table id
             , Periods = "2000MM03"     # March 2000
             , CPI     = "000000"       # Category code for total 
             )
}
}
\seealso{
\code{\link[=cbs_get_meta]{cbs_get_meta()}}, \code{\link[=cbs_download_data]{cbs_download_data()}}

Other data retrieval: \code{\link{cbs_add_date_column}},
  \code{\link{cbs_add_label_columns}},
  \code{\link{cbs_download_data}},
  \code{\link{cbs_extract_table_id}},
  \code{\link{cbs_get_data_from_link}}
}
