% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbs_get_toc.R
\name{cbs_get_toc}
\alias{cbs_get_toc}
\title{Retrieve a data.frame with requested cbs tables}
\usage{
cbs_get_toc(..., convert_dates = TRUE, select = NULL, verbose = FALSE,
  cache = TRUE, base_url = CBSOPENDATA, include_ID = FALSE)
}
\arguments{
\item{...}{filter statement to select rows, e.g. Language="nl"}

\item{convert_dates}{convert the columns with date-time information into DateTime (default \code{TRUE})}

\item{select}{\code{character} columns to be returned, by default all columns
will be returned.}

\item{verbose}{\code{logical} prints the calls to the webservice}

\item{cache}{\code{logical} should the result be cached?}

\item{base_url}{optionally specify a different server. Useful for
third party data services implementing the same protocal.}

\item{include_ID}{\code{logical} column needed by OData but with no current use.}
}
\value{
\code{data.frame} with identifiers, titles and descriptions of tables
}
\description{
\code{cbs_get_toc} by default a list of all tables and all columns will be retrieved.
You can restrict the query by supplying multiple filter statements or by specifying the
columns that should be returned.
}
\note{
\code{cbs_get_toc} will cache results, so subsequent calls will be much faster.
}
\examples{
\dontrun{

# get list of english tables
tables_en <- cbs_get_toc(Language="en")

# get list of dutch tables
tables_nl <- cbs_get_toc(Language="nl")
View(tables_nl)
}
}
