% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-table.R
\name{download_table}
\alias{download_table}
\title{Download a table from statistics Netherlands}
\usage{
download_table(id, ..., dir = id, cache = FALSE, verbose = TRUE,
  typed = FALSE, base_url = CBSOPENDATA)
}
\arguments{
\item{id}{Identifier of CBS table (can be retrieved from \code{\link{get_table_list}})}

\item{...}{Parameters passed on to \code{\link{download_data}}}

\item{dir}{Directory where table should be downloaded}

\item{cache}{If metadata is cached use that, otherwise download meta data}

\item{verbose}{Print extra messages what is happening.}

\item{typed}{Should the data automatically be converted into integer and numeric?}

\item{base_url}{optionally specify a different server. Useful for
third party data services implementing the same protocal.

\code{download_table} retrieves all raw meta data and data and stores these as csv
files in the directory specified by \code{dir}. It is possible to add a filter. 
A filter is specified with \code{<column_name> = <values>} in which \code{<values>} is a character vector.
Rows with values that are not part of the character vector are not returned.}
}
\description{
Download a table from statistics Netherlands
}
\examples{
\dontrun{

# download meta data and data from inflation/Consumer Price Indices
 download_table(id="7196ENG")
}
}
