% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbs_download_meta.R
\name{cbs_download_meta}
\alias{cbs_download_meta}
\title{Dumps the meta data into a directory}
\usage{
cbs_download_meta(
  id,
  dir = id,
  catalog = "CBS",
  ...,
  verbose = FALSE,
  cache = FALSE,
  base_url = getOption("cbsodataR.base_url", BASE_URL)
)
}
\arguments{
\item{id}{Id of CBS open data table (see \code{\link[=cbs_get_toc]{cbs_get_toc()}})}

\item{dir}{Directory in which data should be stored.
By default it creates a sub directory with the name of the id}

\item{catalog}{catalog id, can be retrieved with \code{\link[=cbs_get_datasets]{cbs_get_datasets()}}}

\item{...}{not used}

\item{verbose}{Print extra messages what is happening.}

\item{cache}{Should meta data be cached?}

\item{base_url}{optionally allow to specify a different server. Useful for
third party data services implementing the same protocol.}
}
\value{
meta data object
}
\description{
Dumps the meta data into a directory
}
\seealso{
Other meta data: 
\code{\link{cbs_add_date_column}()},
\code{\link{cbs_add_label_columns}()},
\code{\link{cbs_get_meta}()}

Other download: 
\code{\link{cbs_download_data}()},
\code{\link{cbs_download_table}()}
}
\concept{download}
\concept{meta data}
