% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/usb.R
\name{dusb}
\alias{dusb}
\alias{rusb}
\title{Uniform scaled beta distribution}
\usage{
dusb(x, theta = 0, nu = 5)

rusb(n, theta = 0, nu = 5, quasi = FALSE)
}
\arguments{
\item{x}{vector of quantiles.}

\item{theta}{scale parameter of the USB distribution.}

\item{nu}{smoothness parameter of the USB distribution.}

\item{n}{number of observations.}

\item{quasi}{logical indicating whether quasi random numbers
(\code{\link[qrng:ghalton]{qrng::ghalton()}}) should be used for generating uniforms (which are then
transformed by the quantile function)}
}
\description{
The uniform scaled beta (USB) distribution describes the distribution of
the random variable
\deqn{U_{b, \nu} = U + \theta(B - 0.5),}
where \eqn{U} is a \eqn{U[-0.5, 0.5]} random variable, \eqn{B} is a
\eqn{Beta(\nu, \nu)} random variable, and \eqn{theta > 0, \nu >= 1}.
}
\examples{
# plot distribution
sq <- seq(-0.8, 0.8, by = 0.01)
plot(sq, dusb(sq), type = "l")
lines(sq, dusb(sq, theta = 0.25), col = 2)
lines(sq, dusb(sq, theta = 0.25, nu = 10), col = 3)

# simulate from the distribution
x <- rusb(100, theta = 0.3, nu = 0)

}
\references{
Nagler, T. (2017). \emph{A generic approach to nonparametric function
estimation with mixed data.} \href{https://arxiv.org/pdf/1704.07457.pdf}{arXiv:1704.07457}
}
