% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bindRowsQ.R
\name{bind_rows_q}
\alias{bind_rows_q}
\title{Bind rows by a query. Assumes all tables structured identically.}
\usage{
bind_rows_q(tableNames, colNames, my_db, resultTableName, ...,
  origTableColumn = NULL)
}
\arguments{
\item{tableNames}{names of tables to concatinate (not empty)}

\item{colNames}{names of columns}

\item{my_db}{connection to where tables live}

\item{resultTableName}{name of result table}

\item{...}{force later arguments to bind by name}

\item{origTableColumn}{character, column to put original table name in.}
}
\value{
resultTableName
}
\description{
Bind rows by a query. Assumes all tables structured identically.
}
\examples{

my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
DBI::dbWriteTable(my_db,
                  'd1',
                   data.frame(x=1:2, y= 10:11),
                   overwrite = TRUE,
                   temporary = TRUE)
DBI::dbWriteTable(my_db,
                  'd2',
                   data.frame(x=3:4, y= 13:14),
                   overwrite = TRUE,
                   temporary = TRUE)
bind_rows_q(tableNames = c('d1', 'd2'),
           colNames = c('x', 'y'),
           my_db = my_db,
           resultTableName = 'res1',
           origTableColumn = 'orig_table')
cdata::qlook(my_db, 'res1')
DBI::dbDisconnect(my_db)

}
