% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RowsColsQ.R
\name{qlook}
\alias{qlook}
\title{Quick look at remote data}
\usage{
qlook(my_db, tableName, ..., displayRows = 10, countRows = TRUE,
  qualifiers = NULL)
}
\arguments{
\item{my_db}{database handle}

\item{tableName}{name of table to look at}

\item{...}{force later arguments to be by name.}

\item{displayRows}{number of rows to sample}

\item{countRows}{logical, if TRUE return row count.}

\item{qualifiers}{optional named ordered vector of strings carrying additional db hierarchy terms, such as schema.}
}
\value{
str view of data
}
\description{
Quick look at remote data
}
\examples{

if ( requireNamespace("DBI", quietly = TRUE) &&
  requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  rquery::rq_copy_to(my_db,
                    'd',
                    data.frame(AUC = 0.6, R2 = 0.2),
                    overwrite = TRUE,
                    temporary = TRUE)
  qlook(my_db, 'd')
  DBI::dbDisconnect(my_db)
}

}
\keyword{internal}
