% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.r
\name{cdec_query}
\alias{cdec_query}
\title{Query CDEC}
\usage{
cdec_query(stations, sensors, durations, start.date, end.date, ...)
}
\arguments{
\item{stations}{A vector of station codes.}

\item{sensors}{A vector of sensor numbers.}

\item{durations}{A vector of durations.}

\item{start.date}{The start date of the query.}

\item{end.date}{The end date of the query.}

\item{...}{Not used.}
}
\value{
A dataframe.
}
\description{
Query data from the CDEC web services.
}
\details{
Note that CDEC timestamps are in Pacific Time and
Daylight Savings adjustments are reflected. In R, this is
equivalent to the timezone "US/Pacific".
}
\examples{
if(interactive()){
  cdec_query("NSL", 100, "E", Sys.Date() - 5, Sys.Date())
}

}
