% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrCdf.R, R/qrPdf.R, R/qrqq.R
\name{pq}
\alias{pq}
\alias{dq}
\alias{rq}
\alias{qq}
\alias{pq}
\alias{rq}
\alias{qq}
\title{The Famility of Distributions}
\usage{
pq(q, mu, sigma, fd, sd)

dq(x, mu, sigma, fd, sd)

rq(n, mu, sigma, fd, sd)

qq(p, mu, sigma, fd, sd)
}
\arguments{
\item{q}{vector of quantiles.}

\item{mu}{vector of means.}

\item{sigma}{vector of standard deviations.}

\item{fd}{A string that specifies the parent distribution.}

\item{sd}{A string that specifies the sub-family distribution.}

\item{x}{vector of quantiles.}

\item{n}{Number of random samples.}

\item{p}{vector of probabilities.}
}
\value{
\code{dq} gives the density, \code{rq} generates random variates, \code{qq} gives the quantile function, and \code{pq} gives the cumulative densitity of specified distribution.
}
\description{
Density function, distribution function, quantile function, and random generation of variates for a specified cdf-quantile distribution with \code{mean} equal to mean and standard deviation equal to \code{sd}.
}
\examples{
x <- rq(5, mu = 0.5, sigma = 1, 't2','t2'); x

dq(x, mu = 0.5, sigma = 1, 't2','t2')

qtil <- pq(x, mu = 0.5, sigma = 1, 't2','t2');qtil

qq(qtil , mu = 0.5, sigma = 1, 't2','t2')

}
