% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wg2ws_summarize_cat.R
\name{wg2ws_summarize_cat}
\alias{wg2ws_summarize_cat}
\title{Summarize category table}
\usage{
wg2ws_summarize_cat(category_scores)
}
\arguments{
\item{category_scores}{A 22x2 category result table}
}
\value{
A three column data frame, with total score, lexical, and syntactic
scores
}
\description{
Summarize category table
}
\details{
Given a 22x2 category table, calculate total scores and lexical and
syntax scores.
}
\examples{

words <- c("smile", "old", "chicken (animal)", "breakfast", "snow", "uh oh",
           "please", "bad", "bicycle", "moon")

categories <- wg2ws_items(words)
scores <- wg2ws_summarize_cat(categories)
}
\references{
Day, T. K. M., & Elison, J. T. (2021). A broadened estimate of syntactic
and lexical ability from the MB-CDI. \emph{Journal of Child Language},
49(3), 615-632. \doi{10.1017/S0305000921000283}
}
