% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approxloads.R
\name{approxloads}
\alias{approxloads}
\title{Low Rank Approximation LL' of a Square Symmetrix Matrix R}
\usage{
approxloads(R, r = 3, procr.target = NULL, refl.target = NULL)
}
\arguments{
\item{R}{Square, symmetric matrix R to be approximated}

\item{r}{The required rank of the approximation}

\item{procr.target}{Optional; the target matrix for L in the orthogonal
Procrustes analysis}

\item{refl.target}{Optional; the matrix to check against for possible
reflections of the loading vectors.}
}
\description{
Uses the eigendecomposition of a square, symmetrix matrix R to obtain the
loadings matrix L such that R is approximated by LL', with L restricted to
have \code{r} columns. Hence LL' is a rank \code{r} approximation of R. The
eigendecomposition of R is used to obtain L from the first \code{r}
eigenvectors and eigenvalues. In case \code{procr.target} is not
\code{NULL}, L is further rotated through orthogonal Procrustes analysis to
match as closely as possible the matrix \code{procr.target} through
\code{\link{orthprocr}}.
}
\examples{
R <- rcormat(10, r = 3)
all.equal(R$L, approxloads(R$R, r = 3, procr.target = R$L))
}

