% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle-functions.R
\name{angleSteps}
\alias{angleSteps}
\title{Angle between Two Steps}
\usage{
angleSteps(X, trackids, t, degrees = TRUE, quietly = FALSE)
}
\arguments{
\item{X}{a tracks object}

\item{trackids}{a vector of two indices specifying the tracks to get steps from, or
a dataframe/matrix of two columns (where every row contains a pair of trackids to compute 
a step angle for)}

\item{t}{the timepoint at which the steps should start, or a vector of timepoints if trackids
is a matrix with multiple step pairs to compute angles for.}

\item{degrees}{logical; should angle be returned in degrees instead of radians? (defaults to \code{TRUE})}

\item{quietly}{logical; should a warning be returned if one or both of the steps are missing
in the data and the function returns NA?}
}
\value{
A single angle, or NA if the desired step is missing for one or both
of the tracks. If trackids is a matrix with multiple step pairs to compute angles for,
the output is a numeric vector of angles (or NA values).
}
\description{
Compute the angle between two steps in the dataset that occur at the same timepoint.
}
\examples{
## Find the angle between the steps of the tracks with ids 1 and 2, at the 3rd
## timepoint in the dataset.
t <- timePoints( TCells )[3]
angleSteps( TCells, c("1","3"), t )

## Do this for multiple pairs and times at once: between cells 1 and 3 at the
## 3rd timepoint, and between 1 and 4 at the fourth timepoint.
pairs <- data.frame( cell1 = c("1","1"), cell2 = c("3","4"))
times <- timePoints(TCells)[3:4]
angleSteps( TCells, pairs, times )
}
\seealso{
\code{\link{distanceSteps}} to compute the distance between the step starting
points, \code{\link{timePoints}} to list all timepoints in a dataset,
and \code{\link{AngleAnalysis}} for other methods to compute angles and distances.
}
