% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgmvariables.R
\name{cgmvariables}
\alias{cgmvariables}
\title{Calculate CGM Variables}
\usage{
cgmvariables(inputdirectory = "Cleaned CSVs",
             outputdirectory = tempdir(),
             outputname = "REDCap Upload",
             cgmtype = "iPro")
}
\arguments{
\item{inputdirectory}{The directory containing cleaned CSV files for
analysis.}

\item{outputdirectory}{The directory where you would like the results
spreadsheet to be written.}

\item{outputname}{The name of the file containing final CGM variables.}

\item{cgmtype}{The brand of CGM you are analyzing, either "iPro" or "Dexcom."}
}
\value{
a data frame containing calculated CGM variables, with each column
representing one CGM file.
}
\description{
This function takes cleaned CGM data and returns clinically relevant measures
(e.g. percent time spent over 140). Some variables, like number of glucometer
tests and date of placement will need to be filled in manually in REDCap.
For post-meal glucoses, meals must be determined and entered manually based
on participant food log.
}
\examples{
cgmvariables(system.file("extdata","Cleaned_iPro_CSVs",
                         package = "cgmanalysis"))
cgmvariables(system.file("extdata","Cleaned_Dexcom_CSVs",
                         package = "cgmanalysis"),cgmtype = "Dexcom")
}
