% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgraph.R
\name{cg.parm}
\alias{cg.parm}
\title{Add Parameter}
\arguments{
\item{value}{numeric vector or array, value of the node (optional).}

\item{name}{character scalar, name of the node (optional). In case \code{name} is missing, the node is tried to be added to the graph under an auto-generated name.}
}
\value{
cg.node, parameter.
}
\description{
Add a parameter node to the graph.
}
\details{
\code{$parm(value, name)}
}
\note{
Parameters are assumed to be subject to some optimization process. Hence, their value might change over time.

The name of the parameter node cannot be 'grad' as this is a reserved word.

There is a wrapper function \link[cgraph]{parm} that calls this method on the current active graph.
}
\examples{
# Initialize a new computational graph.
x <- cgraph$new()

# Add a parameter with value 1 and name 'p' to the graph.
x$parm(1, name = "p")

}
\author{
Ron Triepels
}
