# Copyright 2018 Ron Triepels
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

context("Math Operations")

test_that("Scalar [+, -, /, *]",
{
  # Initialize graph
  x <- cgraph$new()

  # Create parameters
  a <- parm(2, name = "a")
  b <- parm(4, name = "b")

  # Create test expression
  c <- (a + b) * (a - b) * (a / b)

  # Calculate gradients
  grads <- gradients(c, run(c))

  # Check gradients
  expect_equivalent(grads$a, approx_grad(c, a), tolerance = 1e-4)
  expect_equivalent(grads$b, approx_grad(c, b), tolerance = 1e-4)
})

test_that("Scalar [+, pow, sqrt]",
{
  # Initialize graph
  x <- cgraph$new()

  # Create parameters
  a <- parm(2, name = "a")
  b <- parm(4, name = "b")

  # Create test expression
  c <- a^b + cg_sqrt(a)

  # Calculate gradients
  grads <- gradients(c, run(c))

  # Check gradients
  expect_equivalent(grads$a, approx_grad(c, a), tolerance = 1e-4)
  expect_equivalent(grads$b, approx_grad(c, b), tolerance = 1e-4)
})

test_that("Scalar [+, ln, log2, log10, exp]",
{
  # Initialize graph
  x <- cgraph$new()

  # Create parameters
  a <- parm(2, name = "a")
  b <- parm(4, name = "b")

  # Create test expression
  c <- cg_ln(a) + cg_log2(b) + cg_log10(a) + cg_exp(b)

  # Calculate gradients
  grads <- gradients(c, run(c))

  # Check gradients
  expect_equivalent(grads$a, approx_grad(c, a), tolerance = 1e-4)
  expect_equivalent(grads$b, approx_grad(c, b), tolerance = 1e-4)
})

test_that("Scalar [-, /, abs]",
{
  # Initialize graph
  x <- cgraph$new()

  # Create parameters
  a <- parm(2, name = "a")
  b <- parm(4, name = "b")

  # Create test expression
  c <- cg_abs(-a / b)

  # Calculate gradients
  grads <- gradients(c, run(c))

  # Check gradients
  expect_equivalent(grads$a, approx_grad(c, a), tolerance = 1e-4)
  expect_equivalent(grads$b, approx_grad(c, b), tolerance = 1e-4)
})
