% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SE.R
\name{Species Endemism}
\alias{Species Endemism}
\alias{SpeciesEndemism}
\title{Calculate species endemism}
\usage{
SpeciesEndemism(rStack)
}
\arguments{
\item{rStack}{a rasterStack of binary species presences}
}
\value{
Raster object showing species endemism.
}
\description{
Calculate species endemism as the number of species in a place divided by the total number of places in which those species are found.
}
\examples{
# create binary raster
r1 <- raster::raster(nrows=108, ncols=108, xmn=-50, xmx=50)
raster::values(r1)<- runif(n = (108*108))
r1[r1 < 0.5] <- NA
r1[r1 > 0.5] <- 1
r2 <- raster::raster(nrows=108, ncols=108, xmn=-50, xmx=50)
raster::values(r2)<- runif(n = (108*108))
r2[r2 < 0.5] <- NA
r2[r2 > 0.5] <- 1
r3 <- raster::raster(nrows=108, ncols=108, xmn=-50, xmx=50)
raster::values(r3)<- runif(n = (108*108))
r3[r3 < 0.5] <- NA
r3[r3 > 0.5] <- 1
rStack <- raster::stack(r1, r2, r3)
# calculate SE
SpeciesEndemism(rStack)
}
\author{
pgalante@amnh.org
}
