% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAR.R
\name{simu.VAR1}
\alias{simu.VAR1}
\title{Simulate from a VAR1 model (without change point).}
\usage{
simu.VAR1(sigma, p, n, A, vzero = NULL)
}
\arguments{
\item{sigma}{A \code{numeric} scalar representing the standard deviation of error terms.}

\item{p}{An \code{integer} scalar representing dimension.}

\item{n}{An \code{integer} scalar representing sample size.}

\item{A}{A \code{numeric} p-by-p matrix representing the transition matrix of the VAR1 model.}

\item{vzero}{A \code{numeric} vector representing the observation at time 0. If \code{vzero = NULL},it is generated following the distribution of the error terms.}
}
\value{
A p-by-n matrix.
}
\description{
Simulate data of size n and dimension p from a VAR1 model (without change point) with Gaussian i.i.d. error terms.
}
\examples{
p = 10
sigma = 1
n = 100
A = matrix(rnorm(p*p), nrow = p)*0.1  # transition matrix
simu.VAR1(sigma, p, n, A)
}
\references{
Wang, Yu, Rinaldo and Willett (2019) <arxiv:1909.06359>
}
\author{
Daren Wang
}
