% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_mean.R
\name{tuneBSunivar}
\alias{tuneBSunivar}
\title{Univariate mean change points detection based on standard or wild binary segmentation with tuning parameter selected by sSIC.}
\usage{
tuneBSunivar(BS_object, y)
}
\arguments{
\item{BS_object}{A "BS" object produced by \code{BS.univar} or \code{WBS.univar}.}

\item{y}{A \code{numeric} vector of observations.}
}
\value{
A \code{list} with the following structure:
 \item{cpt}{A vector of estimated change point locations (sorted in strictly increasing order).}
 \item{tau}{A scalar of selected threshold tau based on sSIC.}
}
\description{
Perform univariate mean change points detection based on standard or wild binary segmentation. The threshold parameter tau for WBS is automatically selected based on the sSIC score defined in Equation (4) in Fryzlewicz (2014).
}
\examples{
set.seed(0)
cpt_true = c(20, 50, 170)
y = rnorm(300) + c(rep(0,20),rep(2,30),rep(0,120),rep(2,130))
## change points detection by WBS
intervals = WBS.intervals(M = 100, lower = 1, upper = length(y))
temp2 = WBS.univar(y, 1, length(y), intervals$Alpha, intervals$Beta, delta = 5)
WBS_result = tuneBSunivar(temp2, y)
cpt_WBS = WBS_result$cpt
Hausdorff.dist(cpt_WBS, cpt_true)
}
\references{
Wang, Yu and Rinaldo (2020) <doi:10.1214/20-EJS1710>;
            Fryzlewicz (2014), Wild binary segmentation for multiple change-point detection, <DOI: 10.1214/14-AOS1245>.
}
\seealso{
\code{\link{BS.univar}} and \code{\link{WBS.univar}}.
}
\author{
Daren Wang & Haotian Xu
}
