% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phonenumbers-provider.R
\name{PhoneNumberProvider}
\alias{PhoneNumberProvider}
\title{PhoneNumberProvider}
\description{
methods for generating phone numbers
}
\examples{
z <- PhoneNumberProvider$new()
z$render()

PhoneNumberProvider$new(locale = "fr_FR")$render()
PhoneNumberProvider$new(locale = "sk_SK")$render()

# locales with area codes
PhoneNumberProvider$new(locale = "en_AU")$render()
PhoneNumberProvider$new(locale = "en_NZ")$render()
PhoneNumberProvider$new(locale = "es_PE")$render()
}
\keyword{internal}
\section{Super class}{
\code{\link[charlatan:BaseProvider]{charlatan::BaseProvider}} -> \code{PhoneNumberProvider}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{locale}}{(character) the locale}

\item{\code{formats}}{phone number formats}

\item{\code{area_code_formats}}{area code formats}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PhoneNumberProvider-allowed_locales}{\code{PhoneNumberProvider$allowed_locales()}}
\item \href{#method-PhoneNumberProvider-new}{\code{PhoneNumberProvider$new()}}
\item \href{#method-PhoneNumberProvider-render}{\code{PhoneNumberProvider$render()}}
\item \href{#method-PhoneNumberProvider-clone}{\code{PhoneNumberProvider$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="bothify"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-bothify'><code>charlatan::BaseProvider$bothify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="check_locale"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-check_locale'><code>charlatan::BaseProvider$check_locale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="lexify"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-lexify'><code>charlatan::BaseProvider$lexify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="numerify"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-numerify'><code>charlatan::BaseProvider$numerify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_digit'><code>charlatan::BaseProvider$random_digit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_not_zero"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_digit_not_zero'><code>charlatan::BaseProvider$random_digit_not_zero()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_not_zero_or_empty"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_digit_not_zero_or_empty'><code>charlatan::BaseProvider$random_digit_not_zero_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_digit_or_empty"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_digit_or_empty'><code>charlatan::BaseProvider$random_digit_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_element"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_element'><code>charlatan::BaseProvider$random_element()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_element_prob"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_element_prob'><code>charlatan::BaseProvider$random_element_prob()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_int"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_int'><code>charlatan::BaseProvider$random_int()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="random_letter"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-random_letter'><code>charlatan::BaseProvider$random_letter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="randomize_nb_elements"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-randomize_nb_elements'><code>charlatan::BaseProvider$randomize_nb_elements()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PhoneNumberProvider-allowed_locales"></a>}}
\if{latex}{\out{\hypertarget{method-PhoneNumberProvider-allowed_locales}{}}}
\subsection{Method \code{allowed_locales()}}{
fetch the allowed locales for this provider
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PhoneNumberProvider$allowed_locales()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PhoneNumberProvider-new"></a>}}
\if{latex}{\out{\hypertarget{method-PhoneNumberProvider-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{PhoneNumberProvider} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PhoneNumberProvider$new(locale = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{locale}}{(character) the locale to use. See
\verb{$allowed_locales()} for locales supported (default: en_US)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{PhoneNumberProvider} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PhoneNumberProvider-render"></a>}}
\if{latex}{\out{\hypertarget{method-PhoneNumberProvider-render}{}}}
\subsection{Method \code{render()}}{
Make a phone number
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PhoneNumberProvider$render()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PhoneNumberProvider-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PhoneNumberProvider-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PhoneNumberProvider$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
