% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequences.R
\name{sequence_}
\alias{sequence_}
\alias{seq_id}
\alias{seq_}
\alias{seq_size}
\alias{window_sequence}
\alias{lag_sequence}
\alias{lead_sequence}
\title{Utilities for creating many sequences}
\usage{
sequence_(size, from = 1L, by = 1L, add_id = FALSE)

seq_id(size)

seq_(from = 1L, to = 1L, by = 1L, add_id = FALSE)

seq_size(from, to, by = 1L)

window_sequence(size, k, partial = TRUE, ascending = TRUE, add_id = FALSE)

lag_sequence(size, k, partial = TRUE, add_id = FALSE)

lead_sequence(size, k, partial = TRUE, add_id = FALSE)
}
\arguments{
\item{size}{Vector of sequence lengths.}

\item{from}{Start of sequence(s).}

\item{by}{Unit increment of sequence(s).}

\item{add_id}{Should the ID numbers of the sequences be added as names?
Default is \code{FALSE}.}

\item{to}{End of sequence(s).}

\item{k}{Window/lag size.}

\item{partial}{Should partial windows/lags be returned? Default is \code{TRUE}.}

\item{ascending}{Should window sequence be ascending? Default is \code{TRUE}.}
}
\value{
A vector of length \code{sum(size)} except for \code{seq_} which
returns a vector of size \code{sum((to - from) / (by + 1))}
}
\description{
\code{sequence_} is an extension to \link{sequence} which
accepts decimal number increments. \cr
\code{seq_id} can be paired with \code{sequence_} to group individual sequences. \cr
\code{seq_} is a vectorised version of \link{seq}. \cr
\code{window_sequence} creates a vector of window sizes for rolling calculations. \cr
\code{lag_sequence} creates a vector of lags for rolling calculations. \cr
\code{lead_sequence} creates a vector of leads for rolling calculations. \cr
}
\details{
\code{sequence_()} works in the same way as \code{sequence()} but can accept
non-integer \code{by} values.
It also recycles \code{from} and \code{to}, in the same way as \code{sequence()}. \cr
If any of the sequences contain values > \code{.Machine$integer.max},
then the result will always be a double vector.

\code{from} can be also be a date, date-time, or any object that supports
addition and multiplication.

\code{seq_()} is a vectorised version of \code{seq()} that strictly accepts
only the arguments \code{from}, \code{to} and \code{by}. \cr
}
\examples{
library(cheapr)
sequence(1:3)
sequence_(1:3)

sequence(1:3, by = 0.1)
sequence_(1:3, by = 0.1)

# Add IDs to the sequences
sequence_(1:3, by = 0.1, add_id = TRUE)
# Turn this quickly into a data frame
enframe_(sequence_(1:3, by = 0.1, add_id = TRUE))

sequence(c(3, 2), by = c(-0.1, 0.1))
sequence_(c(3, 2), by = c(-0.1, 0.1))


# Vectorised version of seq()
seq_(1, 10, by = c(1, 0.5))
# Same as below
c(seq(1, 10, 1), seq(1, 10, 0.5))

# Programmers may use seq_size() to determine final sequence lengths

sizes <- seq_size(1, 10, by = c(1, 0.5))
print(paste(c("sequence sizes: (", sizes, ") total size:", sum(sizes)),
            collapse = " "))

# We can group sequences using seq_id

from <- Sys.Date()
to <- from + 10
by <- c(1, 2, 3)
x <- seq_(from, to, by, add_id = TRUE)
class(x) <- "Date"
x

# Utilities for rolling calculations

window_sequence(c(3, 5), 3)
window_sequence(c(3, 5), 3, partial = FALSE)
window_sequence(c(3, 5), 3, partial = TRUE, ascending = FALSE)
# One can for example use these in data.table::frollsum

}
