% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkArray.r
\name{checkArray}
\alias{assertArray}
\alias{assert_array}
\alias{checkArray}
\alias{expect_array}
\alias{testArray}
\alias{test_array}
\title{Check if an argument is an array}
\usage{
checkArray(x, mode = NULL, any.missing = TRUE, d = NULL, min.d = NULL,
  max.d = NULL)

assertArray(x, mode = NULL, any.missing = TRUE, d = NULL, min.d = NULL,
  max.d = NULL, add = NULL, .var.name)

assert_array(x, mode = NULL, any.missing = TRUE, d = NULL, min.d = NULL,
  max.d = NULL, add = NULL, .var.name)

testArray(x, mode = NULL, any.missing = TRUE, d = NULL, min.d = NULL,
  max.d = NULL)

test_array(x, mode = NULL, any.missing = TRUE, d = NULL, min.d = NULL,
  max.d = NULL)

expect_array(x, mode = NULL, any.missing = TRUE, d = NULL, min.d = NULL,
  max.d = NULL, info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{mode}{[\code{character(1)}]\cr
Storage mode of the array. Arrays can hold vectors, i.e. \dQuote{logical},
\dQuote{integer}, \dQuote{double}, \dQuote{numeric}, \dQuote{complex},
\dQuote{character} and \dQuote{list}. You can also specify \dQuote{atomic}
here to explicitly prohibit lists. Default is \code{NULL} (no check).}

\item{any.missing}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{TRUE}.}

\item{d}{[\code{integer(1)}]\cr
Exact number of dimensions of array \code{x}.
Default is \code{NULL} (no check).}

\item{min.d}{[\code{integer(1)}]\cr
Minimum number of dimensions of array \code{x}.
Default is \code{NULL} (no check).}

\item{max.d}{[\code{integer(1)}]\cr
Maximum number of dimensions of array \code{x}.
Default is \code{NULL} (no check).}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertArray}/\code{assert_array}
 throws an error message, \code{testArray}/\code{test_array}
 returns \code{FALSE},
 and \code{checkArray} returns a string with the error message.
 The function \code{expect_array} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is an array
}
\examples{
checkArray(array(1:27, dim = c(3, 3, 3)), d = 3)
}
\seealso{
Other basetypes: \code{\link{checkAtomicVector}},
  \code{\link{checkAtomic}}, \code{\link{checkCharacter}},
  \code{\link{checkComplex}}, \code{\link{checkDataFrame}},
  \code{\link{checkDataTable}},
  \code{\link{checkEnvironment}},
  \code{\link{checkFactor}}, \code{\link{checkFunction}},
  \code{\link{checkIntegerish}},
  \code{\link{checkInteger}}, \code{\link{checkList}},
  \code{\link{checkLogical}}, \code{\link{checkMatrix}},
  \code{\link{checkNumeric}}, \code{\link{checkVector}}
}

